 @extends('admin.layouts.tabelapp', ['activePage' => 'dashboard', 'titlePage' => __('Dashboard')])

@section('content')
    <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Couriers</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Couriers</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">

            <div class="col-md-12">
            <!-- general form elements -->
            <div class="card card-primary">
              <div onclick="toggleDiv()" class="card-header">
                <h3 class="card-title">Quick Create</h3>
              </div>
              <!-- /.card-header -->
              <!-- form start -->
              <div id="ouickform" style="display: none;">
              <form method="POST" action="{{route('Booking.store')}}">
                @csrf
                <div class="card-body">
                  <div class="form-group">
                    <label for="cust_name">Customer Name</label>
                    <input type="text" class="form-control" name="cust_name"  id="cust_name" placeholder="Enter Customer name" required>
                  </div>
                  <div class="form-group">
                    <label for="forwordingno">Forwording No</label>
                    <input type="text" class="form-control" name="forwordingno"  id="forwordingno" placeholder="Enter Forwording no" required>
                  </div>
                  <div class="form-group">
                    <label for="pickuplocation">Pickup Location</label>
                    <input type="text" class="form-control" name="pickuplocation"  id="pickuplocation" placeholder="Enter Pickup Location" required>
                  </div>
                  <div class="form-group">
                    <label for="deliverylocation">Delivery Location</label>
                    <input type="text" class="form-control" name="deliverylocation"  id="deliverylocation" placeholder="Enter Delivery Location" required>
                  </div>
                </div>
                <!-- /.card-body --> 
                <div class="card-footer">
                  <button type="submit" class="btn btn-primary">Submit</button>
                </div>
              </form>
              </div>
              <script>
                    function toggleDiv() {
                        var div = document.getElementById("ouickform");
                        if (div.style.display === "none" || div.style.display === "") {
                            div.style.display = "block";
                        } else {
                            div.style.display = "none";
                        }
                    }
                </script>
            </div>
            <!-- /.card -->
          </div>
          <div class="col-md-12">
            <!-- general form elements -->
            <div class="card card-primary">
              <div onclick="toggleDivbulk()" class="card-header">
                <h3 class="card-title">Bulk Functions</h3>
              </div>
              <!-- /.card-header -->
                <div class="card-body" id="bulk" style="display: none;">
                <div class="row">
                    <div class="col-md-6">
                        <!-- general form elements -->
            <div class="card card-primary">
              <div class="card-header" style="background-color: #fff;color: black;">
                <h3 class="card-title">Bulk Create</h3>
              </div>
              <!-- /.card-header -->
              <!-- form start -->
              <form method="POST" action="#">
                @csrf
                <div class="card-body">
                  <div class="form-group">
                        <label for="exampleInputFile"><a href="http://track.sbexpresscargo.com/storage/format2create.xlsx" download="format2create.xlsx">Download Format</a></label>
                        <div class="input-group">
                        <div class="custom-file">
                        <input type="file" class="custom-file-input" id="exampleInputFile">
                        <label class="custom-file-label" for="exampleInputFile">Choose file to create </label>
                        </div>
                        </div>
                        </div>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                  <button type="submit" class="btn btn-primary">Create</button>
                </div>
              </form>
            </div>
            <!-- /.card -->
                </div>
                    <div class="col-md-6">
                         <!-- general form elements -->
            <div class="card card-primary">
              <div class="card-header" style="background-color: #fff;color: black;">
                <h3 class="card-title">Bulk Update</h3>
              </div>
              <!-- /.card-header -->
              <!-- form start -->
              <form method="POST" action="#">
                @csrf
                <div class="card-body">
                  <div class="form-group">
                    <div class="form-group">
                        <label for="exampleInputFile2"><a href="#">Download Format</a></label>
                        <div class="input-group">
                        <div class="custom-file">
                        <input type="file" class="custom-file-input" id="exampleInputFile2">
                        <label class="custom-file-label" for="exampleInputFile2">Choose file to update</label>
                        </div>
                        </div>
                        </div>
                  </div>
                </div>
                <!-- /.card-body -->
                <div class="card-footer">
                  <button type="submit" class="btn btn-primary">Update</button>
                </div>
              </form>
            </div>
            <!-- /.card -->
                    </div>
                </div>
                </div>
                <script>
                    function toggleDivbulk() {
                        var div = document.getElementById("bulk");
                        if (div.style.display === "none" || div.style.display === "") {
                            div.style.display = "block";
                        } else {
                            div.style.display = "none";
                        }
                    }
                </script>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <div class="col-12">
            <div class="card">
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example1" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>#</th>
                    <th>Forwording No</th>
                    <th>Customer Name</th>
                    <th>Pickup Location</th>
                    <th>Delivery Location</th>
                    <th>Last Location</th>
                    <th>Status</th>
                    <th>Created At</th>
                    <!-- <th>Active</th> -->
                    <th>Action</th>
                  </tr>
                  </thead>
                  <tbody>
            @if (count($datas) > 0)
            @php ($i = 1)
            @foreach ($datas as $data)
                  <tr>
                    <td>{{ $i }}</td>
                    <td>{{ $data->forwordingno }}</td>
                    <td>{{ $data->cust_name }}</td>
                    <td>{{ $data->pickuplocation }}</td>
                    <td>{{ $data->deliverylocation }}</td>
                    <?php $location = DB::table('bookinglog')->where('bookingno',$data->id)->orderBy('created_at', 'desc')->first();?>
                    <td>{{ $location->currentstatus }}</td>
                    <td>{{ $data->status }}</td>
                    <td>{{ $data->created_at }}</td>
                   <!--  <td><label class="switch">
                    <input type="checkbox">
                    <span class="slider round"></span>
                    </label></td> -->
                    <td>
                      @if ($data->status =="Delivered")
                      <a href="{{route('Booking.show',$data->id)}}" class="btn btn-app"><i class="fas fa-copy"></i> View</a>
                    @else
                        <a href="{{route('Booking.show',$data->id)}}" class="btn btn-app"><i class="fas fa-edit"></i> Edit</a>
                    @endif
                  </td>
                  </tr>
            @php ($i++)   
            @endforeach
            @endif
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>#</th>
                    <th>Forwording No</th>
                    <th>Customer Name</th>
                    <th>Pickup Location</th>
                    <th>Delivery Location</th>
                    <th>Last Location</th>
                    <th>Status</th>
                    <th>Created At</th>
                    <!-- <th>Active</th> -->
                    <th>Action</th>
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    <!-- /.content -->
  </div>
@endsection